<?php

namespace App\Http\Controllers;

use App\Models\Videos;
use Illuminate\Http\Request;
use Illuminate\Database\QueryException;

class VideosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $videos = Videos::where('deleted', false)->get();
        return view('videos.index', compact('videos'));
        //return response()->json($videos);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view('videos.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         //dd($request['title']);
         $request['users_id'] =  auth()->id();
         $request['deleted'] =  0;

         try {
            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'description' => 'required|string',
                'users_id' => 'required|integer|exists:users,id',
                'deleted' => 'integer',
                'embled' => 'required|string|max:2000'
            ]);

            $videos = Videos::create($validatedData);

            return response()->json([
                'message' => 'Video inserido com sucesso.',
                'data' => $videos,
                'response' => 201
            ], 201);

        } catch (QueryException $e) {
            return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json(['error' => 'Erro de validação', 'messages' => $e->errors()], 422);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        try {
       
           $video = Videos::findOrFail($id);
       
           return view('videos.show', compact('video'));
    
            if(!$videos){
                return response()->json(['error' => 'Video não encontrado.'], 404);
            }
    
              return response()->json($videos);
    
            } catch (QueryException $e) {
                return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);
    
            }  catch (\Exception $e) {
                return response()->json(['error' => 'Video não encontrado'], 500);
            }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $video = Videos::findOrFail($id);
        return view('videos.edit', compact('video'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Videos $videos,$id)
    {
        try {
             //dd($request['title']);
            $request['users_id'] =  auth()->id();
            $request['deleted'] =  0;

            $videos = Videos::findOrFail($id);

            if ($videos->deleted) {
                return response()->json(['error' => 'Video não encontrado.'], 404);
            }

            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'description' => 'required|string',
                'users_id' => 'required|integer|exists:users,id',
                'embled' => 'required|string',
                'deleted' => 'integer'
            ]);

            $videos->update($validatedData);

            return response()->json([
                'message' => 'Video atualizado com sucesso.',
                'data' => $videos,
                'response' => 201
            ]);

        } catch (QueryException $e) {
            return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json(['error' => 'Erro de validação', 'messages' => $e->errors()], 422);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Videos $videos,$id)
    {
            try {
                $videos = Videos::findOrFail($id);

                $videos->update(['deleted' => 1]);

                return redirect()->route('videos.index')->with('success', 'Video excluído com sucesso!');

                return response()->json(['message' => 'Video excluído com sucesso.']);

            } catch (\Exception $e) {
                return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
            }
        }

}
