<!-- resources/views/schedule/show.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Detalhes do Evento</h3>
            <a href="{{ route('schedule.index') }}" class="btn btn-secondary float-right">Voltar</a>
        </div>
        <div class="card-body">
            <h4>{{ $schedule->title }}</h4>
            <p><strong>Local do evento:</strong> {{ $schedule->location }}</p>
            <p><strong>Descrição:</strong> {{ $schedule->description }}</p>
            <p><strong>Data:</strong> {{  \Carbon\Carbon::parse($schedule->date)->format('d/m/Y H:i') }}</p>
            @if ($schedule->image)
                <p><strong>Imagem:</strong></p>
                <img src="{{ asset('storage/' . $schedule->image) }}" width="300">
            @endif
        </div>
    </div>
</div>
@endsection
