<!-- resources/views/schedule/show.blade.php -->


<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Detalhes do Evento</h3>
            <a href="<?php echo e(route('schedule.index')); ?>" class="btn btn-secondary float-right">Voltar para a Lista</a>
        </div>
        <div class="card-body">
            <h4><?php echo e($schedule->title); ?></h4>
            <p><strong>Local do evento:</strong> <?php echo e($schedule->location); ?></p>
            <p><strong>Descrição:</strong> <?php echo e($schedule->description); ?></p>
            <p><strong>Data:</strong> <?php echo e(\Carbon\Carbon::parse($schedule->date)->format('d/m/Y H:i')); ?></p>
            <?php if($schedule->image): ?>
                <p><strong>Imagem:</strong></p>
                <img src="<?php echo e(asset('storage/' . $schedule->image)); ?>" width="300">
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sunstonecom/public_html/meercat.sunstone.com.br/meercat/resources/views/schedule/show.blade.php ENDPATH**/ ?>