<!-- resources/views/photos/edit.blade.php -->


<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Editar Foto</h3>
        </div>
        <div class="card-body">
            <form id="photos-form" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" value="<?php echo e($photo->title); ?>" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" rows="5" required><?php echo e($photo->description); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="image">Imagem (opcional)</label>
                    <input type="file" name="image" class="form-control-file">
                </div>
                <?php if($photo->image): ?>
                    <div class="form-group">
                        <p><strong>Imagem Atual:</strong></p>
                        <img src="<?php echo e(asset('storage/' . $photo->image)); ?>" width="100">
                    </div>
                <?php endif; ?>
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn-success">Atualizar
                    <div class="spinner" style="visibility: hidden;"></div>
                    </button>
                    <a href="<?php echo e(route('photo.index')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>
                
            </form>
        </div>
    </div>
</div>
<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#photos-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: "<?php echo e(route('photo.update', $photo->id)); ?>", // Rota para atualizar a foto
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Foto atualizada com sucesso.</div>');
                window.location.href = "<?php echo e(route('photo.index')); ?>";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao atualizar a foto.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao atualizar foto. Tente novamente.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sunstonecom/public_html/meercat.sunstone.com.br/meercat/resources/views/photo/edit.blade.php ENDPATH**/ ?>