<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str; // Adicione esta linha no topo do seu Controller
class CategoryController extends Controller
{
    protected $client;

    public function __construct()
    {
        $this->middleware('auth');

        $this->client = new Client();
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        try {
            // Chamada API com Guzzle
            $response = $this->client->get("http://category.test/api/categories/", [
                'verify' => false,  // Desativa a verificação SSL
                'headers' => [
                    'Content-Type' => 'application/json'
                ],
            ]);

            // Verifica a resposta e obtem o corpo da mesma
            $category = json_decode($response->getBody());


            // Retornar a vista, passando a resposta da API e o id para a view
            return view('category.index', compact('category'));
        } catch (\GuzzleHttp\Exception\ClientException $e) {
            // Capturar erros da chamada API


            // return response()->json(['Error 503: Problema ao se comunicar com a API']);
            // Redireciona de volta com a mensagem de erro
            //return back()->withErrors(['error' => 'Erro ao comunicar com a API']);
        } catch (\Exception $e) {
            // Capturar quaisquer outros erros
            return back()->withErrors(['error' => 'Categoria não encontrada']);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('category.create');
    }



    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Alterado para required
        ]);

        // Capturar o ficheiro enviado
        $image = $request->file('image');

        // Obter o nome original do ficheiro
        $originalName = $image->getClientOriginalName();

        // Fazer o upload da imagem para storage/public/photos
        $path = $image->store('category', 'public');

        try {



            $response = $this->client->post('http://category.test/api/categories', [
                'verify' => false,
                'headers' => [
                    'Content-Type' => 'application/json'
                ],
                'json' => [
                    'title' => $validated['title'],
                    'description' => $validated['description'],
                    'image' => $path,
                    'deleted' => 0
                ]
            ]);

            $body = json_decode($response->getBody(), true);



            if (!isset($body['success']) || !$body['success']) {
                throw new \Exception($body['message'] ?? 'Erro na API');
            }

            return response()->json([
                'success' => true,
                'data' => $body['data']
            ]);
        } catch (\Exception $e) {
            Log::error('Erro ao criar categoria', [
                'error' => $e->getMessage(),
                'request' => $request->all(),
                'trace' => $e->getTraceAsString()
            ]);

            return response()->json([
                'success' => true,
                'error' => $e->getMessage(),
                'data' => $body['data'],
                'response' => 201
            ], 201);
        }
    }
    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        // Capturar o id da request diretamente

        //dd($id);

        try {
            // Chamada API com Guzzle
            $response = $this->client->get("http://category.test/api/categories/{$id}", [
                'verify' => false,  // Desativa a verificação SSL
                'headers' => [
                    'Content-Type' => 'application/json'
                ],
            ]);

            // Verifica a resposta e obtem o corpo da mesma
            $category = json_decode($response->getBody());

            // Retornar a vista, passando a resposta da API e o id para a view
            return view('category.show', compact('category'));
        } catch (\GuzzleHttp\Exception\ClientException $e) {
            // Capturar erros da chamada API


            // return response()->json(['Error 503: Problema ao se comunicar com a API']);
            // Redireciona de volta com a mensagem de erro
            //return back()->withErrors(['error' => 'Erro ao comunicar com a API']);
        } catch (\Exception $e) {
            // Capturar quaisquer outros erros
            return back()->withErrors(['error' => 'Post não encontrado'], 404);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Category $category)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Category $category)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Category $category)
    {
        //
    }
}
