<?php

namespace App\Http\Controllers;

use App\Models\Download;
use App\Models\Music;
use App\Models\Playlist;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class PlaylistController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $playlists = Playlist::where('deleted', false)->get();
        return view('playlist.index', compact('playlists'));
        //return response()->json($playlist);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view('playlist.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $request['users_id'] =  auth()->id();
            $request['deleted'] =  0;
           // dd($request);

            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'description' => 'required|string',
                'users_id' => 'required|integer|exists:users,id',
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:512000',
                'embled' => 'nullable|file|mimes:mp4,flac,mov,avi,mp3,wav,ogg|max:512000',
                'deleted' => 'integer'
            ]);

           // dd( $request);

            if ($request->hasFile('image')) {
                // Capturar o ficheiro enviado
                $image = $request->file('image');

                // Obter o nome original do ficheiro
                $originalName = $image->getClientOriginalName();

                // Fazer o upload da imagem para storage/public/photos
                $path = $image->store('photos', 'public');
            }



            if ($request->hasFile('embled')) {
                // Capturar o ficheiro enviado
                    $midia = $request->file('embled');

                    // Obter o nome original do ficheiro
                    $midia->getClientOriginalName();
        
                    // Fazer o upload da imagem para storage/public/photos
                    $path_midia = $midia->store('media', 'public');

            }


           // Para salvar no banco corretamente:
            $playlist = Playlist::create(array_merge($validatedData, [
                'image' => $path ?? null, // Guarda o caminho final
                'embled' => $path_midia ?? null, // Guarda o caminho final
                'title' => $request['title'],
                'description' => $request['description'],
                'users_id' => $request['user_id'],
                'deleted' => 0
            ]));

          
           

    

            return response()->json([
                'message' => 'Playlist inserida com sucesso.',
                'data' => $playlist,
                'response' => 201
            ], 201);

        } catch (QueryException $e) {
            return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json(['error' => 'Erro de validação', 'messages' => $e->errors()], 422);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Playlist $playlist)
    {
        try {
      
           $playlist = Playlist::findOrFail($playlist->id);
        
           return view('playlist.show', compact('playlist'));
    
            if(!$playlist){
                return response()->json(['error' => 'Playlist não encontrada.'], 404);
            }
    
              return response()->json($playlist);
    
            } catch (QueryException $e) {
                return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);
    
            }  catch (\Exception $e) {
                return response()->json(['error' => 'Playlist não encontrada'], 500);
            }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Playlist $playlist)
    {
        $playlist = Playlist::findOrFail($playlist->id);
        return view('playlist.edit', compact('playlist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Playlist $playlist)
    {
        try {
            $request['users_id'] =  auth()->id();
            $request['deleted'] =  0;
            $playlist = Playlist::findOrFail($playlist->id);

            if ($playlist->deleted) {
                return response()->json(['error' => 'Playlist não encontrada'], 404);
            }

            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'description' => 'required|string',
                'users_id' => 'required|integer|exists:users,id',
                'embled' => 'nullable|file|mimes:mp4,flac,mov,avi,mp3,wav,ogg|max:512000',
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:512000',
                'deleted' => 'integer'
            ]);


            if ($request->hasFile('image')) {
                // Capturar o ficheiro enviado
                $image = $request->file('image');

                // Obter o nome original do ficheiro
                $originalName = $image->getClientOriginalName();

                // Fazer o upload da imagem para storage/public/photos
                $path = $image->store('photos', 'public');
            }



            if ($request->hasFile('embled')) {
                // Capturar o ficheiro enviado
                    $midia = $request->file('embled');

                    // Obter o nome original do ficheiro
                    $midia->getClientOriginalName();
        
                    // Fazer o upload da imagem para storage/public/photos
                    $path_midia = $midia->store('media', 'public');

            }


           // Para salvar no banco corretamente:
            $playlist = Playlist::update(array_merge($validatedData, [
                'image' => $path ?? null, // Guarda o caminho final
                'embled' => $path_midia ?? null, // Guarda o caminho final
                'title' => $request['title'],
                'description' => $request['description'],
                'users_id' => $request['user_id'],
                'deleted' => 0
            ]));

        

            return response()->json([
                'message' => 'Playlist atualizada com sucesso.',
                'data' => $playlist,
                'response' => 201
            ]);

        } catch (QueryException $e) {
            return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json(['error' => 'Erro de validação', 'messages' => $e->errors()], 422);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Playlist $playlist)
    {
            try {
                $playlist = Playlist::findOrFail($playlist->id);

                $playlist->update(['deleted' => 1]);
                return redirect()->route('playlist.index')->with('success', 'Playlist eliminada com sucesso!');
                return response()->json([
                    'message' => 'Playlist excluído com sucesso.',
                    'data' => $playlist
                ]);

            } catch (\Exception $e) {
                return response()->json(['error' => 'Erro: ' . $e->getMessage()], 500);
            }
        }

        public function music(Request $request) {
         // dd($request->all()); // Exibe todos os dados recebidos

        
        if(!Music::where('playlist_id',$request['music_id'])->where('users_id',$request['user_id'])->count())  
         $music = Music::create([
            'playlist_id' =>  $request['music_id'],
            'users_id' => $request['user_id'],
            'view' => 1
          ]);

          return response()->json([
            'message' => 'Dados de visuaçização da música inseridos com  sucesso.',
            'data' => $music
            ]);

        }

        public function download($id) {

         
            // Buscar o arquivo no banco
            $playlist = Playlist::find($id);

            if (!$playlist || !$playlist->embled) {
                return redirect()->back()->with('error', 'Arquivo não encontrado.');
            }

            // Caminho completo do arquivo no storage
            $filePath = storage_path('app/public/' . $playlist->embled);

            // Verifica se o arquivo existe antes de tentar fazer o download
            if (!file_exists($filePath)) {
                return redirect()->back()->with('error', 'Arquivo não encontrado no servidor.');
            }

           

            if(!Download::where('playlist_id',$id)->where('users_id',Auth::user()->id)->count()) { 
                Download::create([
                'playlist_id' =>  $id,
                'users_id' =>Auth::user()->id,
                'view' => 1
                ]);
    
            }
   
            // Força o download do arquivo
           return response()->download($filePath);
        }
}
