<!-- resources/views/photos/show.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Detalhes da Foto</h3>
            <a href="{{ route('photo.index') }}" class="btn btn-secondary float-right">Voltar</a>
        </div>
        <div class="card-body">
            <h4>Título: {{ $photo->title }}</h4>
            <p><strong>Descrição:</strong></p>
            <p>{{ $photo->description }}</p>
            <p><strong>Imagem:</strong></p>
            <div><img src="{{ asset('storage/' . $photo->image) }}" alt="{{ $photo->title }}" width="200"></div>
            <p><strong>Criado em:</strong> {{ $photo->created_at->format('d/m/Y') }}</p>
        </div>
    </div>
</div>
@endsection
