<!-- resources/views/news/create.blade.php -->


<?php $__env->startSection('content'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Criar Novo Post</h3>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('news.store')); ?>" method="POST" >
                <?php echo csrf_field(); ?>
                <input type="hidden" name="users_id" value="<?php echo e(Auth::user()->id); ?>">
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" placeholder="Título da notícia" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" placeholder="Descrição da notícia" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label for="image">Escolher Imagem</label>
                    <input type="file" name="image" class="form-control-file" required>
                </div>
                <div class="errors"></div>
                <div class="form-group">
                    <button type="submit" class="btn btn-success">
                        Salvar
                        <span class="spinner" style="visibility: hidden;"></span> 
                    </button>
                    <a href="<?php echo e(route('news.index')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    
$(document).ready(function () {
   
    // Capturar o evento de submissão do formulário
    $('form').on('submit', function (e) {
        e.preventDefault(); // Prevenir a submissão padrão do formulário
        $('.spinner').css('visibility', 'visible');    
        // Mostrar o indicador de carregamento (exemplo de spinner)
        let loadingIndicator = $('<div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div>');
        $('.buttons').append(loadingIndicator);

        // Criar um FormData com os dados do formulário
        var formData = new FormData(this);
        var id = "<?php echo e($news['id'] ?? ''); ?>"; // Ou definir manualmente, caso esteja disponível
        //alert(id);
        // Enviar o formulário via AJAX
        $.ajax({
            url: "<?php echo e(url('/news')); ?>", // Rota para onde enviar os dados
            type: "POST",
            data: formData,
            processData: false,  // Necessário para enviar FormData
            contentType: false   // Necessário para enviar FormData
        })
        .done(function (response) {
           

           // alert(response.response);

            if (response.response == 201) {
               
                $('.errors').html('');
                $('.errors').append('<div class="alert alert-success">Postagem atualizada com sucesso.</div>');
                 window.location.href = "<?php echo e(route('news.index')); ?>"; 
                //window.location.reload();
            } else {
                 $('.errors').html('');
                    
                 for (let i = 0; i < count; i++) {
                        $('.errors').append("<div class='alert alert-danger'>" + response[0][i] + "</div>" );
                 } 
            }

   
        })
        .fail(function (xhr) {
            // Lidar com o erro (podes mostrar uma mensagem de erro)
            let successMessage = $('<div class="alert alert-danger">Erro ao criar postagem, por favor tente novamente.!</div>');
            $('.errors').html(successMessage)
        })
        .always(function () {
            // Remover o indicador de carregamento
           
            $('.spinner').css('visibility', 'hidden');    
            // Opcional: redefinir o texto do botão ou qualquer outro estado
            // $('.finalize-form').text('deu');
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sunstonecom/public_html/meercat.sunstone.com.br/meercat/resources/views/news/create.blade.php ENDPATH**/ ?>